	function [Gbp, Zbp, Pbp] = PZ_2_G_SYM_BP_S(G, Z, P, Wi2)
	
	% Transforms poles and zeros of an analog lowpass filter with unity cutoff frequency  
	% to a bandpass filter using the geometric symmetric mapping:
	%
	% 	S ->  (s^2 + Wi^2)/s  where Wi2 = Wi^2
	%
	% It is necessary that Wc1*Wc2 = Ws1*Ws2 = Wi^2
	
	% Toolbox for DIGITAL FILTERS USING MATLAB 
	
	% Author: 			Oscar Gustafsson, 
	% Modified by: 		LW 2003-09-19, 2004.09.22
	% Copyright:		by authors - not released for commercial use
	% Version: 			1 
	% Known bugs:		
	% Report bugs to:	Wanhammar@gmail.com
	%
	lnz = length(Z);
	lnp = length(P);
	
	% Transform LP zeros to BP zeros
	for k = 1:lnz
		Zbp(2*k-1) = Z(k)/2 + sqrt((Z(k)^2)/4-Wi2);
		Zbp(2*k) = Z(k)/2 - sqrt((Z(k)^2)/4-Wi2);
	end
	% Transform LP poles to BP poles
	for k = 1:lnp
		Pbp(2*k-1) = P(k)/2 + sqrt((P(k)^2)/4-Wi2);
		Pbp(2*k) = P(k)/2 - sqrt((P(k)^2)/4-Wi2);
	end
	% Transform any zeros at infinity 
	for k = lnz+1:lnp
		Zbp(lnz+k) = 0;
	end
	Zbp = cplxpair(Zbp)';
	Pbp = cplxpair(Pbp)';
	Gbp = G;
	
